#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>

#include "tabcomp.h"
#define CMDFULL 250

char *ejoprom;
static char cmdline[CMDFULL+DIRSIZ+8];
static char history[CMDFULL+DIRSIZ+8];

static struct sgttyb newterm, oldterm;

static ejogetc() {
	char c;
	if(read(0,&c,1)!=1) return -1;
	return c&0177;
}
static ejoputc(c) {
	return write(1,&c,1);	
}
static ejoputs(p) char *p; {
	return write(1,p,strlen(p));
}
static ejoscmp(p,q,n) char *p,*q; {
	int i;
	for(i=0;i<n;i++){
		if(p[i]!=q[i]||!p[i]||!q[i]) return i;
	}
	return n;
}

static int twotabs;
static char namebuf[DIRSIZ+1];
static struct direct nbuf;
static struct stat statbuf;
static char *findit(*p){
	int fd,c,l,rmin;
	char *q,*s;
	namebuf[0]=0;
	for(s=q=p;*q;q++){
		if(*q=='/') s=q+1;
	}
	l=q-s;
	if(l>DIRSIZ) l=DIRSIZ;
	if(s!=p) {
		char t=(*s);
		*s=0;
		fd=open(p,0);
		*s=t;
	} else {
		fd=open(".",0);
	}
	if(fd==-1){
		ejoputc('\007');
		twotabs=1;
		return namebuf;
	}
	fstat(fd,&statbuf);
	if(!(statbuf.st_mode&S_IFDIR)){
		close(fd);
		ejoputc('\007');
		twotabs=1;
		return namebuf;
	}
	c=0;
	while(read(fd,&nbuf,sizeof(struct direct))
			==sizeof(struct direct)){		 
		if(nbuf.d_ino){
			if(ejoscmp(s,nbuf.d_name,l)==l) {
				if(c++){
					int r=ejoscmp(&nbuf.d_name[l],namebuf,DIRSIZ);
					if(r<rmin) rmin=r;
				} else {
					rmin=strlen(&nbuf.d_name[l]);
				}
				strncpy(namebuf,&nbuf.d_name[l],DIRSIZ-l);
				namebuf[DIRSIZ]=0;
			}
		}
	}
	if(c==1) {
		close(fd);
		twotabs=0;
		return namebuf;
	}
	if(c>1&&rmin>0) {
		close(fd);
		twotabs=1;
		namebuf[rmin]=0;
		return namebuf;
	}
	ejoputc('\007');
	if(c==0||twotabs<2) {
		close(fd);
		twotabs=2;
		namebuf[0]=0;
		return namebuf;
	}
	c=0;
	lseek(fd,(long)0,0);
	ejoputs("\r\n");
	while(read(fd,&nbuf,sizeof(struct direct))
			==sizeof(struct direct)){
		if(nbuf.d_ino){
			if(ejoscmp(s,nbuf.d_name,l)==l) {
				int j;
				for(j=0;j<DIRSIZ;j++){
					if(!nbuf.d_name[j]) break;
				}
				write(1,nbuf.d_name,j);
				write(1,"                  ",18-j);
				if(++c%4==0) ejoputs("\r\n");
			}
		}
	}
	close(fd);
	if(c%4!=0) ejoputs("\r\n");
	if(ejoprom) ejoputs(ejoprom);
	ejoputs(cmdline);	
	namebuf[0]=0;
	return namebuf;
}

static char *dotab(i){
	int j=i,fd;
	char *p;
	cmdline[j]=0;
	while(j>0){
		j--;
		if(cmdline[j]==' '||cmdline[j]=='<'
			||cmdline[j]=='>'||cmdline[j]=='|') {
			j++;
			break;
		}
	}
	p=findit(&cmdline[j]);
	while(*p) ejoputc(cmdline[i++]=(*p++));
	cmdline[i]=0;
	if(twotabs>0) return i;
	fd=open(&cmdline[j],0);
	if(fd!=-1){
		struct stat statbuf;
		fstat(fd,&statbuf);
		close(fd);
		if(statbuf.st_mode&S_IFDIR){
			if(j<i&&cmdline[i-1]!='/'){
				ejoputc(cmdline[i++]='/');
			}
		} else {
			ejoputc(cmdline[i++]=' ');
		}
	}
	return i;
}

static domain(){
	int i=0;
	twotabs=0;
	for(;;){
		char c=ejogetc();
		if(c=='\t'){
			i=dotab(i);
		} else if(twotabs=0,c=='\b') {
			if(i>0)	{
				ejoputs("\b \b");
				i--;
			} else {
				ejoputc('\007');
			}
		} else if(c=='\025'){
			if(i>0){
				while(i>0){
					ejoputs("\b \b");
					i--;
				}
			} else {
				ejoputc('\007');
			}
		} else if(c=='\r'||c=='\n') {
			ejoputs("\r\n");
			cmdline[i++]='\n';
			cmdline[i]=0;
			return;
		} else if(c=='\004') {
			if(!i) cmdline[i++]=c;
			if(cmdline[i-1]=='\004'){
				cmdline[i]=0;
				if(i>1) ejoputs("\r\n");
				return;
			}
			ejoputc('^');
			cmdline[i++]=c;
		} else if(c<'\040'||c=='\177') {
			ejoputc('^');
			cmdline[i++]=c;
		} else if(i>=2&&(c=='A'||c=='B')
				&&cmdline[i-1]=='['
				&&cmdline[i-2]=='\033') {
			int j;
			cmdline[i-2]=0;
			while(i>0){
				ejoputs("\b \b");
				i--;
			}
			i=sizeof(cmdline);
			for(j=0;j<sizeof(cmdline);j++){
				char c=history[j];
				history[j]=cmdline[j];
				if(c=='\n'||c==0) {
					c=0;
					if(j<i) i=j;
				}
				cmdline[j]=c;
				if(j<i){
					if(c<'\040'||c=='\177') ejoputc('^');
					else ejoputc(c);
				}
			}
		} else {
			ejoputc(c);
			cmdline[i++]=c;
		}
		if(i>=CMDFULL) {
			cmdline[i]=0;
			return;
		}
	}
	ejoputs("\r\n");
}

static int lp=0;
ejoread(fildes,buffer,nbytes) char *buffer; {
	int r;
	if(fildes==0&&!ioctl(0,TIOCGETP,&oldterm)){
		int i;
		char *p;
		if(!cmdline[lp]){
			newterm=oldterm;
			newterm.sg_flags&=~ECHO&~CRMOD;
			newterm.sg_flags|=CBREAK;
			ioctl(0,TIOCSETP,&newterm);	
			strncpy(history,cmdline,sizeof(history));
			domain();
			ioctl(0,TIOCSETP,&oldterm);
			lp=0;
		}
		p=(&cmdline[lp]);
		for(i=0;i<nbytes;i++){
			if(p[i]&&p[i]!='\004') buffer[i]=p[i];
			else {
				lp+=i;	
				return i;
			}
		}
		lp+=nbytes;
		return nbytes;
	}
	return read(fildes,buffer,nbytes);
}
