/*
 * STevie - ST editor for VI enthusiasts.    ...Tim Thompson...twitch!tjt...
 */

#include <stdio.h>
#include "stevie.h"

/*
 * This stuff is used to provide readable interpretations of unprintable
 * characters.  The 'xxx' in each is replaced with either hex, octal, or
 * decimal numbers, depending on what command-line argument is given.
 */

static char charsbuf[128*6];
struct charinfo chars[] = {
	/* 000 */	2, "^@",
	/* 001 */	2, "^A",
	/* 002 */	2, "^B",
	/* 003 */	2, "^C",
	/* 004 */	2, "^D",
	/* 005 */	2, "^E",
	/* 006 */	2, "^F",
	/* 007 */	2, "^G",
	/* 010 */	2, "^H",
	/* 011 */	2, "^I",
	/* 012 */	1, NULL,
	/* 013 */	2, "^K",
	/* 014 */	2, "^L",
	/* 015 */	2, "^M",
	/* 016 */	2, "^N",
	/* 017 */	2, "^O",
	/* 020 */	2, "^P",
	/* 021 */	2, "^Q",
	/* 022 */	2, "^R",
	/* 023 */	2, "^S",
	/* 024 */	2, "^T",
	/* 025 */	2, "^U",
	/* 026 */	2, "^V",
	/* 027 */	2, "^W",
	/* 030 */	2, "^X",
	/* 031 */	2, "^Y",
	/* 032 */	2, "^Z",
	/* 033 */	2, "^[",
	/* 034 */	2, "^\\",
	/* 035 */	2, "^]",
	/* 036 */	2, "^^",
	/* 037 */	2, "^_",
	/* 040 */	1, NULL,
	/* 041 */	1, NULL,
	/* 042 */	1, NULL,
	/* 043 */	1, NULL,
	/* 044 */	1, NULL,
	/* 045 */	1, NULL,
	/* 046 */	1, NULL,
	/* 047 */	1, NULL,
	/* 050 */	1, NULL,
	/* 051 */	1, NULL,
	/* 052 */	1, NULL,
	/* 053 */	1, NULL,
	/* 054 */	1, NULL,
	/* 055 */	1, NULL,
	/* 056 */	1, NULL,
	/* 057 */	1, NULL,
	/* 060 */	1, NULL,
	/* 061 */	1, NULL,
	/* 062 */	1, NULL,
	/* 063 */	1, NULL,
	/* 064 */	1, NULL,
	/* 065 */	1, NULL,
	/* 066 */	1, NULL,
	/* 067 */	1, NULL,
	/* 070 */	1, NULL,
	/* 071 */	1, NULL,
	/* 072 */	1, NULL,
	/* 073 */	1, NULL,
	/* 074 */	1, NULL,
	/* 075 */	1, NULL,
	/* 076 */	1, NULL,
	/* 077 */	1, NULL,
	/* 100 */	1, NULL,
	/* 101 */	1, NULL,
	/* 102 */	1, NULL,
	/* 103 */	1, NULL,
	/* 104 */	1, NULL,
	/* 105 */	1, NULL,
	/* 106 */	1, NULL,
	/* 107 */	1, NULL,
	/* 110 */	1, NULL,
	/* 111 */	1, NULL,
	/* 112 */	1, NULL,
	/* 113 */	1, NULL,
	/* 114 */	1, NULL,
	/* 115 */	1, NULL,
	/* 116 */	1, NULL,
	/* 117 */	1, NULL,
	/* 120 */	1, NULL,
	/* 121 */	1, NULL,
	/* 122 */	1, NULL,
	/* 123 */	1, NULL,
	/* 124 */	1, NULL,
	/* 125 */	1, NULL,
	/* 126 */	1, NULL,
	/* 127 */	1, NULL,
	/* 130 */	1, NULL,
	/* 131 */	1, NULL,
	/* 132 */	1, NULL,
	/* 133 */	1, NULL,
	/* 134 */	1, NULL,
	/* 135 */	1, NULL,
	/* 136 */	1, NULL,
	/* 137 */	1, NULL,
	/* 140 */	1, NULL,
	/* 141 */	1, NULL,
	/* 142 */	1, NULL,
	/* 143 */	1, NULL,
	/* 144 */	1, NULL,
	/* 145 */	1, NULL,
	/* 146 */	1, NULL,
	/* 147 */	1, NULL,
	/* 150 */	1, NULL,
	/* 151 */	1, NULL,
	/* 152 */	1, NULL,
	/* 153 */	1, NULL,
	/* 154 */	1, NULL,
	/* 155 */	1, NULL,
	/* 156 */	1, NULL,
	/* 157 */	1, NULL,
	/* 160 */	1, NULL,
	/* 161 */	1, NULL,
	/* 162 */	1, NULL,
	/* 163 */	1, NULL,
	/* 164 */	1, NULL,
	/* 165 */	1, NULL,
	/* 166 */	1, NULL,
	/* 167 */	1, NULL,
	/* 170 */	1, NULL,
	/* 171 */	1, NULL,
	/* 172 */	1, NULL,
	/* 173 */	1, NULL,
	/* 174 */	1, NULL,
	/* 175 */	1, NULL,
	/* 176 */	1, NULL,
	/* 177 */	2, "^?",
	/* 200 */	5, NULL,
	/* 201 */	5, NULL,
	/* 202 */	5, NULL,
	/* 203 */	5, NULL,
	/* 204 */	5, NULL,
	/* 205 */	5, NULL,
	/* 206 */	5, NULL,
	/* 207 */	5, NULL,
	/* 210 */	5, NULL,
	/* 211 */	5, NULL,
	/* 212 */	5, NULL,
	/* 213 */	5, NULL,
	/* 214 */	5, NULL,
	/* 215 */	5, NULL,
	/* 216 */	5, NULL,
	/* 217 */	5, NULL,
	/* 220 */	5, NULL,
	/* 221 */	5, NULL,
	/* 222 */	5, NULL,
	/* 223 */	5, NULL,
	/* 224 */	5, NULL,
	/* 225 */	5, NULL,
	/* 226 */	5, NULL,
	/* 227 */	5, NULL,
	/* 230 */	5, NULL,
	/* 231 */	5, NULL,
	/* 232 */	5, NULL,
	/* 233 */	5, NULL,
	/* 234 */	5, NULL,
	/* 235 */	5, NULL,
	/* 236 */	5, NULL,
	/* 237 */	5, NULL,
	/* 240 */	5, NULL,
	/* 241 */	5, NULL,
	/* 242 */	5, NULL,
	/* 243 */	5, NULL,
	/* 244 */	5, NULL,
	/* 245 */	5, NULL,
	/* 246 */	5, NULL,
	/* 247 */	5, NULL,
	/* 250 */	5, NULL,
	/* 251 */	5, NULL,
	/* 252 */	5, NULL,
	/* 253 */	5, NULL,
	/* 254 */	5, NULL,
	/* 255 */	5, NULL,
	/* 256 */	5, NULL,
	/* 257 */	5, NULL,
	/* 260 */	5, NULL,
	/* 261 */	5, NULL,
	/* 262 */	5, NULL,
	/* 263 */	5, NULL,
	/* 264 */	5, NULL,
	/* 265 */	5, NULL,
	/* 266 */	5, NULL,
	/* 267 */	5, NULL,
	/* 270 */	5, NULL,
	/* 271 */	5, NULL,
	/* 272 */	5, NULL,
	/* 273 */	5, NULL,
	/* 274 */	5, NULL,
	/* 275 */	5, NULL,
	/* 276 */	5, NULL,
	/* 277 */	5, NULL,
	/* 300 */	5, NULL,
	/* 301 */	5, NULL,
	/* 302 */	5, NULL,
	/* 303 */	5, NULL,
	/* 304 */	5, NULL,
	/* 305 */	5, NULL,
	/* 306 */	5, NULL,
	/* 307 */	5, NULL,
	/* 310 */	5, NULL,
	/* 311 */	5, NULL,
	/* 312 */	5, NULL,
	/* 313 */	5, NULL,
	/* 314 */	5, NULL,
	/* 315 */	5, NULL,
	/* 316 */	5, NULL,
	/* 317 */	5, NULL,
	/* 320 */	5, NULL,
	/* 321 */	5, NULL,
	/* 322 */	5, NULL,
	/* 323 */	5, NULL,
	/* 324 */	5, NULL,
	/* 325 */	5, NULL,
	/* 326 */	5, NULL,
	/* 327 */	5, NULL,
	/* 330 */	5, NULL,
	/* 331 */	5, NULL,
	/* 332 */	5, NULL,
	/* 333 */	5, NULL,
	/* 334 */	5, NULL,
	/* 335 */	5, NULL,
	/* 336 */	5, NULL,
	/* 337 */	5, NULL,
	/* 340 */	5, NULL,
	/* 341 */	5, NULL,
	/* 342 */	5, NULL,
	/* 343 */	5, NULL,
	/* 344 */	5, NULL,
	/* 345 */	5, NULL,
	/* 346 */	5, NULL,
	/* 347 */	5, NULL,
	/* 350 */	5, NULL,
	/* 351 */	5, NULL,
	/* 352 */	5, NULL,
	/* 353 */	5, NULL,
	/* 354 */	5, NULL,
	/* 355 */	5, NULL,
	/* 356 */	5, NULL,
	/* 357 */	5, NULL,
	/* 360 */	5, NULL,
	/* 361 */	5, NULL,
	/* 362 */	5, NULL,
	/* 363 */	5, NULL,
	/* 364 */	5, NULL,
	/* 365 */	5, NULL,
	/* 366 */	5, NULL,
	/* 367 */	5, NULL,
	/* 370 */	5, NULL,
	/* 371 */	5, NULL,
	/* 372 */	5, NULL,
	/* 373 */	5, NULL,
	/* 374 */	5, NULL,
	/* 375 */	5, NULL,
	/* 376 */	5, NULL,
	/* 377 */	5, NULL,
};

/*
 * octchars()
 *
 * Convert the charinfo strings to octal.
 */
octchars()
{
	int n;
	for ( n=128; n<256; n++ ) {
		chars[n].ch_str=charsbuf+6*(n-128);
		sprintf(chars[n].ch_str,"[%03o]",n);
	}
}

/*
 * hexchars()
 *
 * Convert the charinfo strings to hex.
 */
hexchars()
{
	int n;
	for ( n=128; n<256; n++ ) {
		chars[n].ch_str=charsbuf+6*(n-128);
		sprintf(chars[n].ch_str,"x%02X]",n);
	}
}

/*
 * decchars()
 *
 * Convert the charinfo strings to decimal.
 */
decchars()
{
	int n;
	for ( n=128; n<256; n++ ) {
		chars[n].ch_str=charsbuf+6*(n-128);
		sprintf(chars[n].ch_str,"%3d]",n);
	}
}

hextoint(c)
int c;
{
	if ( c>='0' && c<='9' )
		return(c-'0');
	if ( c>='a' && c<='f' )
		return(10+c-'a');
	if ( c>='A' && c<='F' )
		return(10+c-'A');
	return(-1);
}
