/*
 * STevie - ST editor for VI enthusiasts.    ...Tim Thompson...twitch!tjt...
 */

#include "stevie.h"
#include <stdio.h>
#include <signal.h>
#include <sgtty.h>

struct sgttyb oldterm,newterm;
resterm(){
	ioctl(0,TIOCSETP,&oldterm);
	exit(0);
}

getgeom(width,height) int *width,*height; {
	char c,buf[16];
	int i;
	printf("\0337\033[r\033[999;999H\033[6n\0338");
	fflush(stdout);
	for(i=0;i<sizeof(buf);i++){
		c=getchar();
		if(c=='R') {
			buf[i]=0;
			break;
		}
		buf[i]=c;
	}
	sscanf(&buf[2],"%d;%d",height,width);
}

windinit()
{
	ioctl(0,TIOCGETP,&oldterm);
	signal(SIGINT,resterm);
	signal(SIGQUIT,resterm);
	signal(SIGHUP,resterm);
	newterm=oldterm;
	newterm.sg_flags&=~ECHO&~CRMOD;
	newterm.sg_flags|=CBREAK;
	ioctl(0,TIOCSETP,&newterm);
	getgeom(&Columns,&Rows);
}

windgoto(r,c)
int r,c;
{
	printf("\033[%d;%dH",r+1,c+1);
}

windexit(r)
int r;
{
	ioctl(0,TIOCSETP,&oldterm);
	exit(r);
}

windclear()
{
	printf("\033[H\033[J");
}

windgetc()
{
	return(getchar());
}

windstr(s)
char *s;
{
	printf("%s",s);
}

windputc(c)
int c;
{
	putchar(c);
}

windrefresh()
{
}

beep()
{
	putchar('\007');
}
